#include "plstr.h"
#include "stdio.h"
#include "nsCOMPtr.h"
#include "nsMemory.h"
#include "nsISimple.h"
#include "nsIGenericFactory.h"

// 79e9424f-2c4d-4cae-a762-31b334079252
#define NS_SIMPLE_CID \
{ 0x79e9424f, 0x2c4d, 0x4cae, { 0xa7, 0x62, 0x31, 0xb3, 0x34, 0x07, 0x92, 0x52 } }
#define NS_SIMPLE_CONTRACTID "@mozilla.org/cpp_simple;1"
class nsSimpleImpl : public nsISimple
{
public:
    nsSimpleImpl( );
    virtual ~nsSimpleImpl( );
    // nsISupports interface
    NS_DECL_ISUPPORTS
    NS_DECL_NSISIMPLE
private:
    char* mName;
};
nsSimpleImpl::nsSimpleImpl( ) : mName(nsnull)
{
    // NS_INIT_REFCNT( ); // has been depricated use NS_INIT_ISUPPORTS() 
    NS_INIT_ISUPPORTS(); 
    mName = PL_strdup("default value");
}
// c++ destructor
nsSimpleImpl::~nsSimpleImpl( )
{
    if ( )
        PL_strfree( );
}
// This macro implements the nsISupports interface methods
// QueryInterface, AddRef and Release
NS_IMPL_ISUPPORTS1_CI(nsSimpleImpl, nsISimple);
NS_IMETHODIMP
nsSimpleImpl::GetYourName(char** aName)
{
    NS_PRECONDITION(aName != nsnull, "null ptr");
    if (!aName)
        return NS_ERROR_NULL_POINTER;
    if ( ) {
        *aName = (char*) nsMemory::Alloc(PL_strlen( ) + 1);
        if (! *aName)
            return NS_ERROR_NULL_POINTER;
        PL_strcpy(*aName, );
    }
    else {
        *aName = nsnull;
    }
    return NS_OK;
}
NS_IMETHODIMP
nsSimpleImpl::SetYourName(const char* aName)
{
   NS_PRECONDITION(aName != nsnull, "null ptr");
    if (!aName)
        return NS_ERROR_NULL_POINTER;
    if ( ) {
        PL_strfree( );
    }
     = PL_strdup(aName);
    return NS_OK;
}
NS_IMETHODIMP
nsSimpleImpl::Write( )
{
  printf("%s\n", );
  return NS_OK;
}
NS_IMETHODIMP
nsSimpleImpl::Change(const char* aName)
{
  return SetYourName(aName);
}



NS_GENERIC_FACTORY_CONSTRUCTOR(nsSimpleImpl)
static NS_METHOD nsSimpleRegistrationProc(nsIComponentManager *aCompMgr,
                                          nsIFile *aPath,
                                          const char *registryLocation,
                                          const char *componentType,
                                          const nsModuleComponentInfo *info)
{
    return NS_OK;
}
static NS_METHOD nsSimpleUnregistrationProc(nsIComponentManager *aCompMgr,
                                            nsIFile *aPath,
                                            const char *registryLocation,
                                            const nsModuleComponentInfo *info)
{
    return NS_OK;
}
// For each class that wishes to support nsIClassInfo, add a line like this
NS_DECL_CLASSINFO(nsSimpleImpl)
static nsModuleComponentInfo components[ ] =
{
  { "A Simple Component",    // a message to display when component is loaded
    NS_SIMPLE_CID,           // our UUID 
    NS_SIMPLE_CONTRACTID,    // our human readable PROGID or CLSID
    nsSimpleImplConstructor,
    nsSimpleRegistrationProc      /* NULL if you dont need one */,
    nsSimpleUnregistrationProc    /* NULL if you dont need one */,
    NULL /* no factory destructor */,
    NS_CI_INTERFACE_GETTER_NAME(nsSimpleImpl),
    NULL /* no language helper */,
    &NS_CLASSINFO_NAME(nsSimpleImpl)
  }
};
NS_IMPL_NSGETMODULE(nsSimpleModule, components)